<?php
require_once __DIR__ . '/../../app/config.php';
rp_require_login();

$in = rp_json_input();
$start = isset($in['start']) ? date('Y-m-d', strtotime($in['start'])) : null;
$end   = isset($in['end'])   ? date('Y-m-d', strtotime($in['end']))   : null;
$deptIds = is_array($in['department_ids'] ?? null) ? array_values(array_unique(array_map('intval', $in['department_ids']))) : [];

if (!$start || !$end) {
  $ts = time(); $dow = (int)date('N', $ts);
  $monday = strtotime('-'.($dow-1).' days', $ts);
  $sunday = strtotime('+'.(7-$dow).' days', $ts);
  $start = date('Y-m-d', $monday);
  $end   = date('Y-m-d', $sunday);
}
$startDT = $start.' 00:00:00';
$endDT   = $end.' 23:59:59';

$me = rp_user();
$role = $me['role'] ?? 'member';

if (empty($deptIds)) {
  if (in_array($role, ['admin','manager'], true)) {
    $q = $pdo->query('SELECT id FROM departments WHERE is_active=1');
    $deptIds = array_map('intval', array_column($q->fetchAll(), 'id'));
  } else {
    $stm = $pdo->prepare('SELECT department_id FROM user_departments WHERE user_id=?');
    $stm->execute([$me['id']]);
    $deptIds = array_map('intval', $stm->fetchAll(PDO::FETCH_COLUMN));
    if (empty($deptIds)) rp_json(['ok'=>true,'users'=>[],'shifts'=>[],'range'=>['start'=>$start,'end'=>$end]]);
  }
}
$ph = implode(',', array_fill(0, count($deptIds), '?'));

$stmU = $pdo->prepare("SELECT DISTINCT u.id, COALESCE(u.full_name, u.email) AS name, u.email
                       FROM users u
                       JOIN user_departments ud ON ud.user_id=u.id
                       WHERE u.is_active=1 AND ud.department_id IN ($ph)
                       ORDER BY name");
$stmU->execute($deptIds);
$users = $stmU->fetchAll();

// Filter op status
$statusSql = in_array($role, ['admin','manager'], true) ? "('draft','published')" : "('published')";

$stmS = $pdo->prepare("SELECT s.id, s.department_id, d.name AS department_name,
                              s.title, s.start_at, s.end_at, s.break_minutes,
                              sa.user_id, COALESCE(u.full_name, u.email) AS user_name
                       FROM shifts s
                       JOIN rosters r ON r.id = s.roster_id AND r.status IN $statusSql
                       JOIN departments d ON d.id = s.department_id
                       JOIN shift_assignments sa ON sa.shift_id = s.id
                       JOIN users u ON u.id = sa.user_id
                       WHERE s.start_at <= ? AND s.end_at >= ?
                         AND s.department_id IN ($ph)
                       ORDER BY s.start_at ASC");
$params = array_merge([$endDT, $startDT], $deptIds);
$stmS->execute($params);
$shifts = $stmS->fetchAll();

rp_json(['ok'=>true,'users'=>$users,'shifts'=>$shifts,'range'=>['start'=>$start,'end'=>$end]]);
