'use strict';
(async function(){
  const box = (id)=>document.getElementById(id);
  const a=box('aw-activities'), n=box('aw-notices'), s=box('aw-specials');

  function fill(el, items, type){
    if (!items || !items.length){ el.innerHTML = '<div class="empty">Geen items</div>'; return; }
    el.innerHTML = items.slice(0,5).map(it=>`
      <div class="aw-item">
        <div class="t">${(it.title||'').replace(/[&<>]/g,m=>({ '&':'&amp;','<':'&lt;','>':'&gt;' }[m]))}
          <span class="tag ${type}">${type}</span>
        </div>
        ${it.message?`<div class="m">${(it.message||'').replace(/[&<>]/g,m=>({ '&':'&amp;','<':'&lt;','>':'&gt;' }[m]))}</div>`:''}
      </div>
    `).join('');
  }

  try{
    const res = await fetch('/api/announcements/my-today.php');
    const data = await res.json();
    const items = data.ok ? data.items : {activity:[],notice:[],special:[]};
    fill(a, items.activity, 'activity');
    fill(n, items.notice, 'notice');
    fill(s, items.special, 'special');
  }catch(_){
    a.innerHTML=n.innerHTML=s.innerHTML='<div class="empty">Kon items niet laden</div>';
  }
})();
