'use strict';

(async function(){
  const $ = (q)=>document.querySelector(q);

  const deptChecks = $('#deptChecks');
  const q = $('#q');
  const list = $('#list');
  const empty = $('#empty');
  const reloadBtn = $('#reloadBtn');
  const resetBtn = $('#resetBtn');

  let departments = [];
  let selectedDeptIds = new Set();

  const days = ['ma','di','wo','do','vr','za','zo']; // 1..7

  function esc(s){ return (s||'').replace(/[&<>"]/g, c=>({ '&':'&amp;','<':'&lt;','>':'&gt;' }[c])); }

  async function loadDepartments(){
    const res = await fetch('/api/departments/list.php').then(r=>r.json());
    departments = res.ok ? res.items : [];
    deptChecks.innerHTML = '';
    departments.forEach(d=>{
      const lab = document.createElement('label');
      lab.className = 'check';
      lab.innerHTML = `<input type="checkbox" value="${d.id}"><span>${esc(d.name)}</span>`;
      const cb = lab.querySelector('input');
      cb.addEventListener('change', ()=> {
        if (cb.checked) selectedDeptIds.add(Number(cb.value));
        else selectedDeptIds.delete(Number(cb.value));
      });
      deptChecks.appendChild(lab);
    });
  }

  function timeBadge(a){ // a: {start:'HH:MM:SS', end:'HH:MM:SS'}
    if (!a || !a.start || !a.end) return '';
    // label met HH:MM-HH:MM
    const s = a.start.slice(0,5), e = a.end.slice(0,5);
    return `<span class="slot ok">${s}–${e}</span>`;
  }

  function render(items){
    list.innerHTML = '';
    if (!items || !items.length){ empty.hidden = false; return; }
    empty.hidden = true;

    items.forEach(u=>{
      const row = document.createElement('div');
      row.className = 'gridRow';

      // user + departments
      const ucol = document.createElement('div');
      ucol.className = 'colUser';
      const depts = (u.departments||[]).map(d=> `<span class="badge dept">${esc(d.name)}</span>`).join(' ');
      ucol.innerHTML = `<div>
          <div style="font-weight:600">${esc(u.name)}</div>
          <div class="help">${esc(u.email||'')}</div>
          <div style="margin-top:6px;display:flex;gap:6px;flex-wrap:wrap">${depts}</div>
        </div>`;
      row.appendChild(ucol);

      for (let w=1; w<=7; w++){
        const dcol = document.createElement('div');
        dcol.className = 'colDay';
        dcol.setAttribute('data-label', days[w-1].toUpperCase());
        const slots = (u.days && u.days[w] ? u.days[w] : []);
        dcol.innerHTML = slots.length
          ? slots.map(timeBadge).join(' ')
          : '<span class="slot warn">—</span>';
        row.appendChild(dcol);
      }
      list.appendChild(row);
    });
  }

  async function load(){
    const depIds = Array.from(selectedDeptIds);
    const body = { department_ids: depIds, search: (q.value||'').trim() };
    const res = await fetch('/api/availability/list-all.php', {
      method:'POST',
      headers:{'Content-Type':'application/json'},
      body: JSON.stringify(body)
    });
    const data = await res.json();
    render(data.ok ? data.items : []);
  }

  reloadBtn.addEventListener('click', load);
  resetBtn.addEventListener('click', ()=>{ selectedDeptIds.clear(); deptChecks.querySelectorAll('input[type="checkbox"]').forEach(cb=>cb.checked=false); q.value=''; load(); });
  q.addEventListener('keydown', (e)=>{ if(e.key==='Enter'){ e.preventDefault(); load(); }});

  await loadDepartments();
  await load();
})();
