<?php
require_once __DIR__ . '/../config.php';
rp_require_login();
?>
<!DOCTYPE html>
<html lang="nl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Mijn profiel – Roosterprogramma</title>
  <link rel="stylesheet" href="style.css">
</head>
<body>
  <header class="topbar">
    <div class="brand"><a href="/app/dashboard/" class="back">←</a> Mijn profiel</div>
    <nav class="nav">
      <a href="/app/dashboard/" class="navlink">Dashboard</a>
      <a href="/api/auth/logout.php" class="navlink">Log uit</a>
    </nav>
  </header>

  <main class="wrap">
    <section class="card">
      <h1 class="title">Profielgegevens</h1>
      <form id="profileForm" class="form" novalidate>
        <div class="grid">
          <div class="field">
            <label>E-mail (alleen-lezen)</label>
            <input id="email" type="email" disabled />
          </div>
          <div class="field">
            <label for="phone">06-nummer (optioneel)</label>
            <input id="phone" type="tel" placeholder="06 12345678 of +31612345678" />
            <small class="muted">Gebruik een NL 06-nummer</small>
          </div>
        </div>

        <div class="grid">
          <div class="field">
            <label for="first">Voornaam</label>
            <input id="first" type="text" required />
          </div>
          <div class="field">
            <label for="last">Achternaam</label>
            <input id="last" type="text" required />
          </div>
        </div>

        <div class="field">
          <label>Afdelingen (min. 1)</label>
          <div id="deptList" class="checks"></div>
          <small class="muted" id="deptHelp">Kies minimaal één afdeling.</small>
        </div>

        <div class="actions">
          <button type="submit" class="btn">Opslaan</button>
          <a class="link" href="/app/dashboard/">Annuleren</a>
        </div>

        <div id="note" class="note" hidden></div>
      </form>
    </section>

    <section class="card">
      <h2 class="subtitle">Wachtwoord wijzigen</h2>
      <form id="pwdForm" class="form" novalidate>
        <div class="grid">
          <div class="field">
            <label for="currentPwd">Huidig wachtwoord</label>
            <input id="currentPwd" type="password" autocomplete="current-password" required />
          </div>
          <div class="field">
            <label for="newPwd">Nieuw wachtwoord</label>
            <input id="newPwd" type="password" placeholder="Minimaal 8 tekens" autocomplete="new-password" required />
          </div>
        </div>
        <div class="field">
          <label for="newPwd2">Herhaal nieuw wachtwoord</label>
          <input id="newPwd2" type="password" autocomplete="new-password" required />
        </div>
        <div class="actions">
          <button type="submit" class="btn secondary">Wachtwoord opslaan</button>
        </div>
        <div id="pwdNote" class="note" hidden></div>
      </form>
    </section>
  </main>

  <script src="app.js"></script>
</body>
</html>
